package ibase.webitm.ejb.vhb.msq1;


import java.rmi.RemoteException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class QuotationApproved extends ValidatorEJB {
    String usersiteCode = "";
    E12GenericUtility genericUtility = new E12GenericUtility();

    public QuotationApproved(UserInfoBean userInfoBean) {
        setUserInfo(userInfoBean);
        userInfoBean = getUserInfo();
        usersiteCode = userInfoBean.getSiteCode();
        BaseLogger.log("3", getUserInfo(), null, "usersiteCode : " + usersiteCode);
    }

    public HashMap<String, ArrayList<String>> getQuotationRates(String itemCode) throws ITMException, SQLException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        LinkedHashMap<String, ArrayList<String>> quotationRatesMap = new LinkedHashMap<>();
        int count = 0;
        String customerCode = "" , quotNo = "" , addDate = "" ,aprvRate = "";
        String sql = "SELECT sq.cust_code,sqdet.quot_no, sq.add_date,sqdet.item_code,sqdet.aprv_rate FROM sales_quot sq LEFT JOIN sales_quotdet sqdet ON sq.quot_no = sqdet.quot_no WHERE sq.status = 'A' AND sqdet.item_code = ? AND sq.add_date IS NOT NULL ORDER BY sq.add_date DESC";
        try {
            BaseLogger.log("3", getUserInfo(), null, "Fetching last 3 quotation rates for item_code: " + itemCode);

            conn = getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, itemCode); 
            rs = pstmt.executeQuery();

            while (rs.next())
            {
                ArrayList<String> quotationDetails = new ArrayList<>();
                customerCode = checkNull(rs.getString("cust_code"));
                quotNo = checkNull(rs.getString("quot_no"));
                addDate = checkNull(rs.getString("add_date"));
                itemCode =  checkNull(rs.getString("item_code"));
                aprvRate = checkNull(rs.getString("aprv_rate"));
  
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getDBDateFormat());
                java.util.Date addDateUtil = simpleDateFormat.parse(addDate);
                SimpleDateFormat displayFormat = new SimpleDateFormat("dd/MM/yy");
                String formattedAddDate = displayFormat.format(addDateUtil);

                quotationDetails.add(customerCode);
                quotationDetails.add(quotNo);
                quotationDetails.add(formattedAddDate);
                quotationDetails.add(itemCode);
                quotationDetails.add(aprvRate);


                quotationRatesMap.put(String.valueOf(count), quotationDetails);
                count++;
            }

        } 
        catch (Exception e) 
        {
            BaseLogger.log("3", getUserInfo(), null, "Exception in getLastThreeQuotationRates: " + e.getMessage());
            throw new ITMException(e);
        }
        finally
        {

            if (rs != null) {
                rs.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }

        return quotationRatesMap;
    }

    private String checkNull(String str)
    {
        if (str == null) {
            return "";
        } else {
            return str;
        }
    }
}
